clear all
set more off
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

use wf_step1011.dta, clear
capture log close
log using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\log_files\log_step5002.log, replace

*** Population weights
egen sum_age_total = sum(age_total) if smpl2==1, by(year country)
gen pop_wgt =  age_total/sum_age_total


gen flag_0=1

gen flag_1=1
replace flag_1=0 if country=="US" | country=="CA"

gen flag_2=1
replace flag_2=0 if country=="IT" | country=="ES"

gen flag_3=1
replace flag_3=0 if country=="FR" | country=="DE"

gen flag_4=1
replace flag_4=0 if country=="SE" | country=="FI" | country=="DK"


*==============================================================
*				Estimation sample
*==============================================================

reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1  , robust beta 
			
keep if e(sample)


foreach ss in 0 1 2 3 4  {

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		+ controls 
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			[aw=pop_wgt]  if smpl2==1 & flag_`ss'==1, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	

if `ss'==0 {			  
outreg2  ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///			
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table5002", ///
			replace	dta ctitle("OLS") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			year_school hh_size home_own_rate  netmig_rate ///	(OTHER CONTROLS)	
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  /// (OTHER CONTROLS)
			logY_ppp   urban_share_500_y1990 mlog_road_density city_nuts capital /// (OTHER CONTROLS)
			turnmig_rate  ///
			)
}			
			
if `ss'~=0 {			  
outreg2  ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///			
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table5002", ///
			append	dta ctitle("OLS") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			year_school hh_size home_own_rate  netmig_rate ///	(OTHER CONTROLS)	
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  /// (OTHER CONTROLS)
			logY_ppp   urban_share_500_y1990 mlog_road_density city_nuts capital /// (OTHER CONTROLS)
			turnmig_rate  ///
			)
}			
			
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		controls only + FE
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1 & flag_`ss'==1, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
			  
outreg2  ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///			
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table5002", ///
			append	dta ctitle("FE") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)
			
}
			
			
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
outreg2  ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table5002", ///
			groupvar( ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			Controls ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)	
			
	
		
log close
	

	
